/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.fileProcessors;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.rat.config.exclusion.MatcherSet;
import org.apache.rat.config.exclusion.fileProcessors.AbstractFileProcessorBuilder;
import org.apache.rat.document.DocumentName;

public final class HgIgnoreBuilder
extends AbstractFileProcessorBuilder {
    private static final Pattern SYNTAX_CHECK = Pattern.compile("^\\s?syntax:\\s+(glob|regexp)\\s?");
    private Syntax state = Syntax.REGEXP;

    public HgIgnoreBuilder() {
        super(".hgignore", "#", true);
    }

    @Override
    protected MatcherSet process(Consumer<MatcherSet> matcherSetConsumer, DocumentName root, DocumentName documentName) {
        this.state = Syntax.REGEXP;
        return super.process(matcherSetConsumer, root, documentName);
    }

    @Override
    public Optional<String> modifyEntry(Consumer<MatcherSet> matcherSetConsumer, DocumentName documentName, String entry) {
        Matcher m = SYNTAX_CHECK.matcher(entry.toLowerCase(Locale.ROOT));
        if (m.matches()) {
            this.state = Syntax.valueOf(m.group(1).toUpperCase());
            return Optional.empty();
        }
        if (this.state == Syntax.REGEXP) {
            String pattern = entry.startsWith("^") ? entry.substring(1) : ".*" + entry;
            return Optional.of(String.format("%%regex[%s]", pattern));
        }
        if (entry.startsWith("*")) {
            return Optional.of("**/" + entry);
        }
        return Optional.of(entry);
    }

    static enum Syntax {
        REGEXP,
        GLOB;

    }
}

