/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import java.io.CharArrayWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.documentation.options.AntOption;
import org.apache.rat.documentation.options.MavenOption;
import org.apache.rat.help.AbstractHelp;

public final class Naming {
    private static final Option WIDTH = Option.builder().longOpt("width").type(Integer.class).desc("Set the display width of the output").hasArg().build();
    private static final Option MAVEN = Option.builder().longOpt("maven").desc("Produce Maven name mapping").build();
    private static final Option ANT = Option.builder().longOpt("ant").desc("Produce Ant name mapping").build();
    private static final Option CSV = Option.builder().longOpt("csv").desc("Produce CSV format").build();
    private static final Option CLI = Option.builder().longOpt("cli").desc("Produce CLI name mapping").build();
    private static final Option INCLUDE_DEPRECATED = Option.builder().longOpt("include-deprecated").desc("Include deprecated options.").build();
    private static final Options OPTIONS = new Options().addOption(MAVEN).addOption(ANT).addOption(CLI).addOption(CSV).addOption(INCLUDE_DEPRECATED).addOption(WIDTH);

    private Naming() {
    }

    public static void main(String[] args) throws IOException, ParseException {
        if (args == null || args.length < 1) {
            System.err.println("At least one argument is required: path to file is missing.");
            return;
        }
        CommandLine cl = DefaultParser.builder().build().parse(OPTIONS, args);
        int width = Math.max(cl.getParsedOptionValue(WIDTH, Integer.valueOf(120)), 120);
        boolean showMaven = cl.hasOption(MAVEN);
        boolean showAnt = cl.hasOption(ANT);
        boolean includeDeprecated = cl.hasOption(INCLUDE_DEPRECATED);
        Predicate<Option> filter = o -> o.hasLongOpt() && (!o.isDeprecated() || includeDeprecated);
        ArrayList<String> columns = new ArrayList<String>();
        if (cl.hasOption(CLI)) {
            columns.add("CLI");
        }
        if (showAnt) {
            columns.add("Ant");
        }
        if (showMaven) {
            columns.add("Maven");
        }
        columns.add("Description");
        columns.add("Argument Type");
        Function<Option, String> descriptionFunction = cl.hasOption(CLI) || !showAnt && !showMaven ? o -> {
            StringBuilder desc = new StringBuilder();
            if (o.isDeprecated()) {
                desc.append("[").append(o.getDeprecated().toString()).append("] ");
            }
            return desc.append(StringUtils.defaultIfEmpty(o.getDescription(), "")).toString();
        } : (showAnt ? o -> {
            StringBuilder desc = new StringBuilder();
            AntOption antOption = new AntOption((Option)o);
            if (antOption.isDeprecated()) {
                desc.append("[").append(antOption.getDeprecated()).append("] ");
            }
            return desc.append(StringUtils.defaultIfEmpty(antOption.getDescription(), "")).toString();
        } : o -> {
            StringBuilder desc = new StringBuilder();
            MavenOption mavenOption = new MavenOption((Option)o);
            if (mavenOption.isDeprecated()) {
                desc.append("[").append(mavenOption.getDeprecated()).append("] ");
            }
            return desc.append(StringUtils.defaultIfEmpty(mavenOption.getDescription(), "")).toString();
        });
        try (OutputStreamWriter underWriter = cl.getArgs().length != 0 ? new FileWriter(cl.getArgs()[0]) : new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);){
            if (cl.hasOption(CSV)) {
                Naming.printCSV(columns, filter, cl.hasOption(CLI), showMaven, showAnt, descriptionFunction, underWriter);
            } else {
                Naming.printText(columns, filter, cl.hasOption(CLI), showMaven, showAnt, descriptionFunction, underWriter, width);
            }
        }
    }

    private static List<String> fillColumns(List<String> columns, Option option, boolean addCLI, boolean showMaven, boolean showAnt, Function<Option, String> descriptionFunction) {
        if (addCLI) {
            if (option.hasLongOpt()) {
                columns.add("--" + option.getLongOpt());
            } else {
                columns.add("-" + option.getOpt());
            }
        }
        if (showAnt) {
            columns.add(new AntOption(option).getExample());
        }
        if (showMaven) {
            columns.add(new MavenOption(option).getExample());
        }
        columns.add(descriptionFunction.apply(option));
        columns.add(option.hasArgName() ? option.getArgName() : (option.hasArgs() ? "Strings" : (option.hasArg() ? "String" : "-- none --")));
        columns.add(option.hasArgName() ? option.getArgName() : (option.hasArgs() ? "Strings" : (option.hasArg() ? "String" : "-- none --")));
        columns.add(option.hasArgName() ? option.getArgName() : (option.hasArgs() ? "Strings" : (option.hasArg() ? "String" : "-- none --")));
        return columns;
    }

    private static void printCSV(List<String> columns, Predicate<Option> filter, boolean addCLI, boolean showMaven, boolean showAnt, Function<Option, String> descriptionFunction, Writer underWriter) throws IOException {
        try (CSVPrinter printer = new CSVPrinter(underWriter, CSVFormat.DEFAULT.builder().setQuoteMode(QuoteMode.ALL).get());){
            printer.printRecord(columns);
            for (Option option : OptionCollection.buildOptions().getOptions()) {
                if (!filter.test(option)) continue;
                columns.clear();
                printer.printRecord(Naming.fillColumns(columns, option, addCLI, showMaven, showAnt, descriptionFunction));
            }
        }
    }

    private static int[] calculateColumnWidth(int width, int columnCount, List<List<String>> page) {
        int i;
        int[] columnWidth = new int[columnCount];
        for (List<String> row : page) {
            for (int i2 = 0; i2 < columnCount; ++i2) {
                columnWidth[i2] = Math.max(columnWidth[i2], row.get(i2).length());
            }
        }
        int extra = 0;
        int averageWidth = (width - (columnCount - 1) * 2) / columnCount;
        int[] overage = new int[columnCount];
        int totalOverage = 0;
        for (i = 0; i < columnCount; ++i) {
            if (columnWidth[i] < averageWidth) {
                extra += averageWidth - columnWidth[i];
                continue;
            }
            if (columnWidth[i] <= averageWidth) continue;
            overage[i] = columnWidth[i] - averageWidth;
            totalOverage += overage[i];
        }
        for (i = 0; i < columnCount; ++i) {
            if (overage[i] <= 0) continue;
            int addl = (int)((double)(extra * overage[i]) * 1.0 / (double)totalOverage);
            columnWidth[i] = averageWidth + addl;
        }
        return columnWidth;
    }

    private static void printText(List<String> columns, Predicate<Option> filter, boolean addCLI, boolean showMaven, boolean showAnt, Function<Option, String> descriptionFunction, Writer underWriter, int width) throws IOException {
        ArrayList<List<String>> page = new ArrayList<List<String>>();
        int columnCount = columns.size();
        page.add(columns);
        for (Option option : OptionCollection.buildOptions().getOptions()) {
            if (!filter.test(option)) continue;
            page.add(Naming.fillColumns(new ArrayList<String>(), option, addCLI, showMaven, showAnt, descriptionFunction));
        }
        int[] columnWidth = Naming.calculateColumnWidth(width, columnCount, page);
        HelpFormatter helpFormatter = new HelpFormatter.Builder().get();
        helpFormatter.setWidth(width);
        ArrayList<LinkedList<String>> entries = new ArrayList<LinkedList<String>>();
        CharArrayWriter cWriter = new CharArrayWriter();
        for (List list : page) {
            entries.clear();
            PrintWriter writer = new PrintWriter(cWriter);
            for (int i = 0; i < columnCount; ++i) {
                String col = (String)list.get(i);
                for (String line : col.split("\\v")) {
                    helpFormatter.printWrapped(writer, columnWidth[i], 2, line);
                }
                writer.flush();
                LinkedList<String> entryLines = new LinkedList<String>(Arrays.asList(cWriter.toString().split("\\v")));
                entries.add(entryLines);
                cWriter.reset();
            }
            boolean cont = true;
            while (cont) {
                cont = false;
                for (int columnNumber = 0; columnNumber < entries.size(); ++columnNumber) {
                    Deque queue = (Deque)entries.get(columnNumber);
                    if (queue.isEmpty()) {
                        underWriter.append(AbstractHelp.createPadding(columnWidth[columnNumber] + 2));
                        continue;
                    }
                    String ln = (String)queue.pop();
                    underWriter.append(ln);
                    underWriter.append(AbstractHelp.createPadding(columnWidth[columnNumber] - ln.length() + 2));
                    if (queue.isEmpty()) continue;
                    cont = true;
                }
                underWriter.append(System.lineSeparator());
            }
            underWriter.append(System.lineSeparator());
        }
    }
}

