/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationDroppedTablesTestBase
extends TestReplicationBase {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationDroppedTablesTestBase.class);
    protected static final int ROWS_COUNT = 1000;
    protected static byte[] VALUE;
    private static boolean ALLOW_PROCEEDING;

    protected static void setupClusters(boolean allowProceeding) throws Exception {
        CONF1.setInt("hbase.ipc.max.request.size", 65536);
        VALUE = new byte[4096];
        ThreadLocalRandom.current().nextBytes(VALUE);
        NUM_SLAVES1 = 1;
        NUM_SLAVES2 = 1;
        ALLOW_PROCEEDING = allowProceeding;
        CONF1.setBoolean("hbase.replication.drop.on.deleted.table", allowProceeding);
        CONF1.setInt("hbase.replication.source.maxthreads", 1);
        TestReplicationBase.setUpBeforeClass();
    }

    protected final byte[] generateRowKey(int id) {
        return Bytes.toBytes((String)String.format("NormalPut%03d", id));
    }

    protected final void testEditsBehindDroppedTable(String tName) throws Exception {
        Put put;
        TableName tablename = TableName.valueOf((String)tName);
        byte[] familyName = Bytes.toBytes((String)"fam");
        byte[] row = Bytes.toBytes((String)"row");
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tablename).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setScope(1).build()).build();
        Connection connection1 = ConnectionFactory.createConnection((Configuration)UTIL1.getConfiguration());
        Connection connection2 = ConnectionFactory.createConnection((Configuration)UTIL2.getConfiguration());
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createTable(table);
        }
        var9_9 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable(table);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        UTIL1.waitUntilAllRegionsAssigned(tablename);
        UTIL2.waitUntilAllRegionsAssigned(tablename);
        admin1 = connection1.getAdmin();
        var9_9 = null;
        try {
            admin1.disableReplicationPeer("2");
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var9_9 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        var9_9 = null;
        try (Table droppedTable = connection1.getTable(tablename);){
            byte[] rowKey = Bytes.toBytes((String)"0 put on table to be dropped");
            put = new Put(rowKey);
            put.addColumn(familyName, row, VALUE);
            droppedTable.put(put);
        }
        catch (Throwable rowKey) {
            var9_9 = rowKey;
            throw rowKey;
        }
        var9_9 = null;
        try (Table table1 = connection1.getTable(tableName);){
            for (int i = 0; i < 1000; ++i) {
                put = new Put(this.generateRowKey(i)).addColumn(famName, row, VALUE);
                table1.put(put);
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        admin1 = connection1.getAdmin();
        var9_9 = null;
        try {
            admin1.disableTable(tablename);
            admin1.deleteTable(tablename);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var9_9 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        admin2 = connection2.getAdmin();
        var9_9 = null;
        try {
            admin2.disableTable(tablename);
            admin2.deleteTable(tablename);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (admin2 != null) {
                if (var9_9 != null) {
                    try {
                        admin2.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    admin2.close();
                }
            }
        }
        admin1 = connection1.getAdmin();
        var9_9 = null;
        try {
            admin1.enableReplicationPeer("2");
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var9_9 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        if (ALLOW_PROCEEDING) {
            this.verifyReplicationProceeded();
        } else {
            this.verifyReplicationStuck();
        }
    }

    private boolean peerHasAllNormalRows() throws IOException {
        try (ResultScanner scanner = htable2.getScanner(new Scan());){
            Result[] results = scanner.next(1000);
            if (results.length != 1000) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < results.length; ++i) {
                Assert.assertArrayEquals((byte[])this.generateRowKey(i), (byte[])results[i].getRow());
            }
            boolean bl = true;
            return bl;
        }
    }

    protected final void verifyReplicationProceeded() throws Exception {
        for (int i = 0; i < 50; ++i) {
            if (i == 49) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (this.peerHasAllNormalRows()) break;
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
    }

    protected final void verifyReplicationStuck() throws Exception {
        for (int i = 0; i < 50; ++i) {
            if (this.peerHasAllNormalRows()) {
                Assert.fail((String)"Edit should have been stuck behind dropped tables");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
    }
}

