/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.util;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static String findLastNotEmptyWord(String[] words) {
        for (int i = words.length - 1; i >= 0; --i) {
            if (words[i].isBlank()) continue;
            return words[i];
        }
        return "";
    }

    public static String findLastNotEmptyWordBeforeWordFromEnd(String[] words, String word) {
        if (word.isBlank()) {
            throw new IllegalArgumentException("word must not be blank");
        }
        if (words.length == 0) {
            return "";
        }
        boolean beforeWordFound = false;
        for (int i = words.length - 1; i >= 0; --i) {
            String currentWord = words[i];
            if (currentWord.isBlank()) continue;
            if (beforeWordFound) {
                return currentWord;
            }
            if (!currentWord.equals(word)) continue;
            beforeWordFound = true;
        }
        return "";
    }

    public static boolean firstStartsWithSecond(String[] array1, String[] array2) {
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("Arrays cannot be null and the first array cannot be shorter than the second");
        }
        if (array1.length < array2.length) {
            return false;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }
}

