/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.exceptions.response.DefaultErrorContext;
import io.micronaut.http.server.exceptions.response.Error;
import java.util.List;
import java.util.Optional;

public interface ErrorContext {
    @NonNull
    public HttpRequest<?> getRequest();

    @NonNull
    public Optional<Throwable> getRootCause();

    @NonNull
    public List<Error> getErrors();

    default public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    @NonNull
    public static Builder builder(@NonNull HttpRequest<?> request) {
        return DefaultErrorContext.builder(request);
    }

    public static interface Builder {
        @NonNull
        public Builder cause(@Nullable Throwable var1);

        @NonNull
        public Builder errorMessage(@NonNull String var1);

        @NonNull
        public Builder error(@NonNull Error var1);

        @NonNull
        public Builder errorMessages(@NonNull List<String> var1);

        @NonNull
        public Builder errors(@NonNull List<Error> var1);

        @NonNull
        public ErrorContext build();
    }
}

