/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.io.Externalizable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxy;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformJob;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformAbstractJob
implements PlatformJob,
Externalizable {
    static final Object LOC_JOB_RES = new Object();
    @IgniteInstanceResource
    protected transient Ignite ignite;
    protected transient PlatformAbstractTask task;
    protected transient long ptr;
    protected Object job;
    protected String jobName;

    protected PlatformAbstractJob() {
    }

    protected PlatformAbstractJob(PlatformAbstractTask task, long ptr, Object job, String jobName) {
        this.task = task;
        this.ptr = ptr;
        this.job = job;
        this.jobName = jobName;
    }

    @Override
    @Nullable
    public Object execute() {
        try {
            PlatformProcessor interopProc = PlatformUtils.platformProcessor(this.ignite);
            interopProc.awaitStart();
            return this.execute0(interopProc.context());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    protected abstract Object execute0(PlatformContext var1) throws IgniteCheckedException;

    protected boolean createJob(PlatformContext ctx) throws IgniteCheckedException {
        if (this.ptr == 0L) {
            try (PlatformMemory mem = ctx.memory().allocate();){
                PlatformOutputStream out = mem.output();
                BinaryRawWriterEx writer = ctx.writer(out);
                writer.writeObject(this.job);
                out.synchronize();
                this.ptr = ctx.gateway().computeJobCreate(mem.pointer());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runLocal(PlatformContext ctx, boolean cancel, PlatformTargetProxy ses) {
        if (this.task.onJobLock()) {
            try {
                ctx.gateway().computeJobExecuteLocal(this.ptr, cancel ? 1L : 0L, ses);
                Object object = LOC_JOB_RES;
                return object;
            }
            finally {
                this.task.onJobUnlock();
            }
        }
        return null;
    }

    @Override
    public long pointer() {
        return this.ptr;
    }

    @Override
    public Object job() {
        return this.job;
    }

    @Override
    public String name() {
        return this.jobName;
    }
}

