/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class Decimal64ColSubtractDecimal64Column
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public Decimal64ColSubtractDecimal64Column(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public Decimal64ColSubtractDecimal64Column() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        block19: {
            long outputDecimal64AbsMax;
            long[] vector2;
            long[] vector1;
            int[] sel;
            Decimal64ColumnVector inputColVector2;
            Decimal64ColumnVector inputColVector1;
            int n;
            block18: {
                long result;
                n = batch.size;
                if (n == 0) {
                    return;
                }
                if (this.childExpressions != null) {
                    super.evaluateChildren(batch);
                }
                inputColVector1 = (Decimal64ColumnVector)batch.cols[this.colNum1];
                inputColVector2 = (Decimal64ColumnVector)batch.cols[this.colNum2];
                Decimal64ColumnVector outputColVector = (Decimal64ColumnVector)batch.cols[this.outputColumnNum];
                sel = batch.selected;
                vector1 = inputColVector1.vector;
                vector2 = inputColVector2.vector;
                long[] outputVector = outputColVector.vector;
                boolean[] outputIsNull = outputColVector.isNull;
                outputDecimal64AbsMax = HiveDecimalWritable.getDecimal64AbsMax(outputColVector.precision);
                NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
                if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block18;
                outputVector[0] = result = vector1[0] - vector2[0];
                if (Math.abs(result) <= outputDecimal64AbsMax) break block19;
                outputColVector.noNulls = false;
                outputIsNull[0] = true;
                break block19;
            }
            if (inputColVector1.isRepeating) {
                long repeatedValue1 = vector1[0];
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        outputVector[i] = result = repeatedValue1 - vector2[i];
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        long result;
                        outputVector[i] = result = repeatedValue1 - vector2[i];
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                long repeatedValue2 = vector2[0];
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        outputVector[i] = result = vector1[i] - repeatedValue2;
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        long result;
                        outputVector[i] = result = vector1[i] - repeatedValue2;
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    long result;
                    int i = sel[j];
                    outputVector[i] = result = vector1[i] - vector2[i];
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputColVector.noNulls = false;
                    outputIsNull[i] = true;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    long result;
                    outputVector[i] = result = vector1[i] - vector2[i];
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputColVector.noNulls = false;
                    outputIsNull[i] = true;
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

