/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.traverser.Steps;
import org.apache.hugegraph.util.E;

public class KoutRequest {
    @JsonProperty(value="source")
    private Object source = null;
    @JsonProperty(value="steps")
    public Steps steps = null;
    @JsonProperty(value="max_depth")
    public int maxDepth = 5000;
    @JsonProperty(value="nearest")
    public boolean nearest = true;
    @JsonProperty(value="count_only")
    public boolean countOnly = false;
    @JsonProperty(value="capacity")
    public long capacity = 10000000L;
    @JsonProperty(value="limit")
    public long limit = 10L;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;
    @JsonProperty(value="with_path")
    public boolean withPath = false;
    @JsonProperty(value="with_edge")
    public boolean withEdge = false;
    @JsonProperty(value="traverse_mode")
    public String traverseMode = "breadth_first_search";

    private KoutRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("KoutRequest{source=%s,steps=%s,maxDepth=%snearest=%s,countOnly=%s,capacity=%s,limit=%s,withVertex=%s,withPath=%s,withEdge=%s,traverseMode=%s}", this.source, this.steps, this.maxDepth, this.nearest, this.countOnly, this.capacity, this.limit, this.withVertex, this.withPath, this.withEdge, this.traverseMode);
    }

    public static class Builder {
        private final KoutRequest request = new KoutRequest();
        private Steps.Builder stepsBuilder = Steps.builder();

        private Builder() {
        }

        public Builder source(Object source) {
            E.checkNotNull((Object)source, (String)"source");
            this.request.source = source;
            return this;
        }

        public Steps.Builder steps() {
            Steps.Builder builder;
            this.stepsBuilder = builder = Steps.builder();
            return builder;
        }

        public Builder maxDepth(int maxDepth) {
            TraversersAPI.checkPositive(maxDepth, "max depth");
            this.request.maxDepth = maxDepth;
            return this;
        }

        public Builder nearest(boolean nearest) {
            this.request.nearest = nearest;
            return this;
        }

        public Builder countOnly(boolean countOnly) {
            this.request.countOnly = countOnly;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder limit(long limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public Builder withPath(boolean withPath) {
            this.request.withPath = withPath;
            return this;
        }

        public Builder withEdge(boolean withEdge) {
            this.request.withEdge = withEdge;
            return this;
        }

        public KoutRequest build() {
            E.checkNotNull((Object)this.request.source, (String)"The source can't be null");
            this.request.steps = this.stepsBuilder.build();
            E.checkNotNull((Object)this.request.steps, (String)"steps");
            TraversersAPI.checkPositive(this.request.maxDepth, "max depth");
            TraversersAPI.checkCapacity(this.request.capacity);
            TraversersAPI.checkLimit(this.request.limit);
            if (this.request.countOnly) {
                E.checkArgument((!this.request.withVertex && !this.request.withPath && !this.request.withEdge ? 1 : 0) != 0, (String)"Can't return vertex or path or edgewhen count only is true", (Object[])new Object[0]);
            }
            return this.request;
        }
    }
}

