/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.entity.schema.SchemaStyle;
import org.springframework.util.CollectionUtils;

public class EdgeLabelStyle
extends SchemaStyle {
    @JsonProperty(value="color")
    private String color;
    @JsonProperty(value="with_arrow")
    private Boolean withArrow;
    @JsonProperty(value="line_type")
    private LineType lineType;
    @JsonProperty(value="thickness")
    private Thickness thickness;
    @JsonProperty(value="display_fields")
    private List<String> displayFields;
    @JsonProperty(value="join_symbols")
    private List<String> joinSymbols;

    public EdgeLabelStyle() {
        this(null, null, null, null, null, null);
    }

    @JsonCreator
    public EdgeLabelStyle(@JsonProperty(value="color") String color, @JsonProperty(value="with_arrow") Boolean withArrow, @JsonProperty(value="line_type") LineType lineType, @JsonProperty(value="thickness") Thickness thickness, @JsonProperty(value="display_fields") List<String> displayFields, @JsonProperty(value="join_symbols") List<String> joinSymbols) {
        this.color = !StringUtils.isEmpty((CharSequence)color) ? color : "#5C73E6";
        this.withArrow = withArrow != null ? withArrow : true;
        this.lineType = lineType != null ? lineType : LineType.SOLID;
        this.thickness = thickness != null ? thickness : Thickness.NORMAL;
        this.displayFields = !CollectionUtils.isEmpty(displayFields) ? displayFields : ImmutableList.of((Object)"~id");
        this.joinSymbols = !CollectionUtils.isEmpty(joinSymbols) ? joinSymbols : ImmutableList.of((Object)"-");
    }

    public static EdgeLabelStyleBuilder builder() {
        return new EdgeLabelStyleBuilder();
    }

    public String getColor() {
        return this.color;
    }

    public Boolean getWithArrow() {
        return this.withArrow;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public Thickness getThickness() {
        return this.thickness;
    }

    public List<String> getDisplayFields() {
        return this.displayFields;
    }

    public List<String> getJoinSymbols() {
        return this.joinSymbols;
    }

    @JsonProperty(value="color")
    public void setColor(String color) {
        this.color = color;
    }

    @JsonProperty(value="with_arrow")
    public void setWithArrow(Boolean withArrow) {
        this.withArrow = withArrow;
    }

    @JsonProperty(value="line_type")
    public void setLineType(LineType lineType) {
        this.lineType = lineType;
    }

    @JsonProperty(value="thickness")
    public void setThickness(Thickness thickness) {
        this.thickness = thickness;
    }

    @JsonProperty(value="display_fields")
    public void setDisplayFields(List<String> displayFields) {
        this.displayFields = displayFields;
    }

    @JsonProperty(value="join_symbols")
    public void setJoinSymbols(List<String> joinSymbols) {
        this.joinSymbols = joinSymbols;
    }

    public String toString() {
        return "EdgeLabelStyle(color=" + this.getColor() + ", withArrow=" + this.getWithArrow() + ", lineType=" + (Object)((Object)this.getLineType()) + ", thickness=" + (Object)((Object)this.getThickness()) + ", displayFields=" + this.getDisplayFields() + ", joinSymbols=" + this.getJoinSymbols() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdgeLabelStyle)) {
            return false;
        }
        EdgeLabelStyle other = (EdgeLabelStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        Boolean this$withArrow = this.getWithArrow();
        Boolean other$withArrow = other.getWithArrow();
        if (this$withArrow == null ? other$withArrow != null : !((Object)this$withArrow).equals(other$withArrow)) {
            return false;
        }
        LineType this$lineType = this.getLineType();
        LineType other$lineType = other.getLineType();
        if (this$lineType == null ? other$lineType != null : !((Object)((Object)this$lineType)).equals((Object)other$lineType)) {
            return false;
        }
        Thickness this$thickness = this.getThickness();
        Thickness other$thickness = other.getThickness();
        if (this$thickness == null ? other$thickness != null : !((Object)((Object)this$thickness)).equals((Object)other$thickness)) {
            return false;
        }
        List<String> this$displayFields = this.getDisplayFields();
        List<String> other$displayFields = other.getDisplayFields();
        if (this$displayFields == null ? other$displayFields != null : !((Object)this$displayFields).equals(other$displayFields)) {
            return false;
        }
        List<String> this$joinSymbols = this.getJoinSymbols();
        List<String> other$joinSymbols = other.getJoinSymbols();
        return !(this$joinSymbols == null ? other$joinSymbols != null : !((Object)this$joinSymbols).equals(other$joinSymbols));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EdgeLabelStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        Boolean $withArrow = this.getWithArrow();
        result = result * 59 + ($withArrow == null ? 43 : ((Object)$withArrow).hashCode());
        LineType $lineType = this.getLineType();
        result = result * 59 + ($lineType == null ? 43 : ((Object)((Object)$lineType)).hashCode());
        Thickness $thickness = this.getThickness();
        result = result * 59 + ($thickness == null ? 43 : ((Object)((Object)$thickness)).hashCode());
        List<String> $displayFields = this.getDisplayFields();
        result = result * 59 + ($displayFields == null ? 43 : ((Object)$displayFields).hashCode());
        List<String> $joinSymbols = this.getJoinSymbols();
        result = result * 59 + ($joinSymbols == null ? 43 : ((Object)$joinSymbols).hashCode());
        return result;
    }

    public static class EdgeLabelStyleBuilder {
        private String color;
        private Boolean withArrow;
        private LineType lineType;
        private Thickness thickness;
        private List<String> displayFields;
        private List<String> joinSymbols;

        EdgeLabelStyleBuilder() {
        }

        @JsonProperty(value="color")
        public EdgeLabelStyleBuilder color(String color) {
            this.color = color;
            return this;
        }

        @JsonProperty(value="with_arrow")
        public EdgeLabelStyleBuilder withArrow(Boolean withArrow) {
            this.withArrow = withArrow;
            return this;
        }

        @JsonProperty(value="line_type")
        public EdgeLabelStyleBuilder lineType(LineType lineType) {
            this.lineType = lineType;
            return this;
        }

        @JsonProperty(value="thickness")
        public EdgeLabelStyleBuilder thickness(Thickness thickness) {
            this.thickness = thickness;
            return this;
        }

        @JsonProperty(value="display_fields")
        public EdgeLabelStyleBuilder displayFields(List<String> displayFields) {
            this.displayFields = displayFields;
            return this;
        }

        @JsonProperty(value="join_symbols")
        public EdgeLabelStyleBuilder joinSymbols(List<String> joinSymbols) {
            this.joinSymbols = joinSymbols;
            return this;
        }

        public EdgeLabelStyle build() {
            return new EdgeLabelStyle(this.color, this.withArrow, this.lineType, this.thickness, this.displayFields, this.joinSymbols);
        }

        public String toString() {
            return "EdgeLabelStyle.EdgeLabelStyleBuilder(color=" + this.color + ", withArrow=" + this.withArrow + ", lineType=" + (Object)((Object)this.lineType) + ", thickness=" + (Object)((Object)this.thickness) + ", displayFields=" + this.displayFields + ", joinSymbols=" + this.joinSymbols + ")";
        }
    }

    public static enum Thickness {
        THICK,
        NORMAL,
        FINE;

    }

    public static enum LineType {
        SOLID,
        DASHED,
        DOTTED;

    }
}

