/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.flink;

import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.loader.builder.EdgeBuilder;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.builder.VertexBuilder;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.VertexMapping;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.graph.BatchEdgeRequest;
import org.apache.hugegraph.structure.graph.BatchVertexRequest;
import org.apache.hugegraph.structure.graph.UpdateStrategy;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class HugeGraphOutputFormat<T>
extends RichOutputFormat<T> {
    private static final Logger LOG = Log.logger(HugeGraphOutputFormat.class);
    private static final long serialVersionUID = -4514164348993670086L;
    private LoadContext loadContext;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private volatile transient boolean closed = false;
    private final LoadOptions loadOptions;
    private final InputStruct struct;
    private Map<ElementBuilder, List<String>> builders;

    public HugeGraphOutputFormat(InputStruct struct, String[] args) {
        this.struct = struct;
        this.loadOptions = LoadOptions.parseOptions(args);
    }

    private Map<ElementBuilder, List<String>> initBuilders() {
        LoadContext loadContext = new LoadContext(this.loadOptions);
        HashMap<ElementBuilder, List<String>> builders = new HashMap<ElementBuilder, List<String>>();
        for (VertexMapping vertexMapping : this.struct.vertices()) {
            builders.put(new VertexBuilder(loadContext, this.struct, vertexMapping), new ArrayList());
        }
        for (EdgeMapping edgeMapping : this.struct.edges()) {
            builders.put(new EdgeBuilder(loadContext, this.struct, edgeMapping), new ArrayList());
        }
        loadContext.updateSchemaCache();
        return builders;
    }

    public void configure(Configuration configuration) {
    }

    public void open(int taskNumber, int numTasks) {
        this.builders = this.initBuilders();
        this.loadContext = new LoadContext(this.loadOptions);
        int flushIntervalMs = this.loadOptions.flushIntervalMs;
        if (flushIntervalMs > 0) {
            this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ExecutorThreadFactory("hugegraph-streamload-outputformat"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this::flushAll, flushIntervalMs, flushIntervalMs, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void flushAll() {
        if (this.closed) {
            return;
        }
        try {
            for (Map.Entry<ElementBuilder, List<String>> builder : this.builders.entrySet()) {
                List<String> graphElements = builder.getValue();
                if (graphElements.size() <= 0) continue;
                this.flush(builder.getKey(), graphElements);
            }
        }
        catch (Exception e) {
            throw new LoadException("Failed to flush all data.", e);
        }
    }

    public synchronized void writeRecord(T row) {
        for (Map.Entry<ElementBuilder, List<String>> builder : this.builders.entrySet()) {
            ElementMapping elementMapping = builder.getKey().mapping();
            if (elementMapping.skip()) continue;
            List<String> graphElements = builder.getValue();
            graphElements.add(row.toString());
            this.flush(builder.getKey(), builder.getValue());
        }
    }

    private Tuple2<String, List<GraphElement>> buildGraphData(ElementBuilder elementBuilder, String row) {
        JsonNode node;
        try {
            node = new ObjectMapper().readTree(row);
        }
        catch (JsonProcessingException e) {
            throw new ParseException(row, (Throwable)e);
        }
        JsonNode data = node.get("data");
        String op = node.get("op").asText();
        String[] fields = this.struct.input().header();
        Object[] values = new String[data.size()];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = data.get(fields[i]).asText();
        }
        return Tuple2.of((Object)op, elementBuilder.build(fields, values));
    }

    private void flush(ElementBuilder<GraphElement> elementBuilder, List<String> rows) {
        GraphManager g = this.loadContext.client().graph();
        ElementMapping elementMapping = elementBuilder.mapping();
        block5: for (String row : rows) {
            Tuple2<String, List<GraphElement>> graphData = this.buildGraphData(elementBuilder, row);
            List graphElements = (List)graphData.f1;
            boolean isVertex = elementBuilder.mapping().type().isVertex();
            switch (Envelope.Operation.forCode((String)((String)graphData.f0))) {
                case READ: 
                case CREATE: {
                    if (isVertex) {
                        g.addVertices(graphElements);
                        continue block5;
                    }
                    g.addEdges(graphElements);
                    continue block5;
                }
                case UPDATE: {
                    BatchVertexRequest.Builder req;
                    Map<String, UpdateStrategy> updateStrategyMap = elementMapping.updateStrategies();
                    if (isVertex) {
                        req = new BatchVertexRequest.Builder();
                        req.vertices(graphElements).updatingStrategies(updateStrategyMap).createIfNotExist(true);
                        g.updateVertices(req.build());
                        continue block5;
                    }
                    req = new BatchEdgeRequest.Builder();
                    req.edges(graphElements).updatingStrategies(updateStrategyMap).checkVertex(this.loadOptions.checkVertex).createIfNotExist(true);
                    g.updateEdges(req.build());
                    continue block5;
                }
                case DELETE: {
                    String id = ((GraphElement)graphElements.get(0)).id().toString();
                    if (isVertex) {
                        g.removeVertex((Object)id);
                        continue block5;
                    }
                    g.removeEdge(id);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("The type of `op` should be 'c' 'r' 'u' 'd' only");
        }
        rows.clear();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduler.shutdown();
        }
    }
}

