/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.util;

import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.implementation.models.DataLakeStorageExceptionInternal;
import com.azure.storage.file.datalake.implementation.models.PathExpiryOptions;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathsGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.util.AccessorUtility;
import com.azure.storage.file.datalake.models.DataLakeAclChangeFailedException;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.PathPermissions;
import com.azure.storage.file.datalake.models.PathSystemProperties;
import com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

public class ModelHelper {
    private static final ClientLogger LOGGER = new ClientLogger(ModelHelper.class);
    private static final long MAX_APPEND_FILE_BYTES = 0xFA000000L;
    public static final long FILE_DEFAULT_MAX_SINGLE_UPLOAD_SIZE = 0x6400000L;
    private static final long FILE_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000L;
    private static final int FILE_DEFAULT_NUMBER_OF_BUFFERS = 8;

    public static ParallelTransferOptions populateAndApplyDefaults(ParallelTransferOptions other) {
        Long maxSingleUploadSize;
        Integer maxConcurrency;
        Long blockSize;
        ParallelTransferOptions parallelTransferOptions = other = other == null ? new ParallelTransferOptions() : other;
        if (other.getBlockSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.blockSize", (long)other.getBlockSizeLong(), (long)1L, (long)0xFA000000L);
        }
        if (other.getMaxSingleUploadSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.maxSingleUploadSize", (long)other.getMaxSingleUploadSizeLong(), (long)1L, (long)0xFA000000L);
        }
        if ((blockSize = other.getBlockSizeLong()) == null) {
            blockSize = 0x400000L;
        }
        if ((maxConcurrency = other.getMaxConcurrency()) == null) {
            maxConcurrency = 8;
        }
        if ((maxSingleUploadSize = other.getMaxSingleUploadSizeLong()) == null) {
            maxSingleUploadSize = 0x6400000L;
        }
        return new ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressListener(other.getProgressListener()).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static DataLakeAclChangeFailedException changeAclRequestFailed(DataLakeStorageException e, String continuationToken) {
        String message = String.format("An error occurred while recursively changing the access control list. See the exception of type %s with status=%s and error code=%s for more information. You can resume changing the access control list using continuationToken=%s after addressing the error.", ((Object)((Object)e)).getClass(), e.getStatusCode(), e.getErrorCode(), continuationToken);
        return new DataLakeAclChangeFailedException(message, e, continuationToken);
    }

    public static DataLakeAclChangeFailedException changeAclFailed(Exception e, String continuationToken) {
        String message = String.format("An error occurred while recursively changing the access control list. See the exception of type %s for more information. You can resume changing the access control list using continuationToken=%s after addressing the error.", e.getClass(), continuationToken);
        return new DataLakeAclChangeFailedException(message, e, continuationToken);
    }

    public static PathExpiryOptions setFieldsIfNull(DataLakePathCreateOptions options, PathResourceType pathResourceType) {
        if (pathResourceType == PathResourceType.DIRECTORY) {
            if (options.getProposedLeaseId() != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("ProposedLeaseId does not apply to directories."));
            }
            if (options.getLeaseDuration() != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("LeaseDuration does not apply to directories."));
            }
            if (options.getScheduleDeletionOptions() != null && options.getScheduleDeletionOptions().getTimeToExpire() != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("TimeToExpire does not apply to directories."));
            }
            if (options.getScheduleDeletionOptions() != null && options.getScheduleDeletionOptions().getExpiresOn() != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("ExpiresOn does not apply to directories."));
            }
        }
        if (options.getScheduleDeletionOptions() == null) {
            return null;
        }
        if (options.getScheduleDeletionOptions().getTimeToExpire() != null && options.getScheduleDeletionOptions().getExpiresOn() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("TimeToExpire and ExpiresOn both cannot be set."));
        }
        if (options.getScheduleDeletionOptions().getTimeToExpire() != null) {
            return PathExpiryOptions.RELATIVE_TO_NOW;
        }
        if (options.getScheduleDeletionOptions().getExpiresOn() != null) {
            return PathExpiryOptions.ABSOLUTE;
        }
        return null;
    }

    public static String buildMetadataString(Map<String, String> metadata) {
        if (!CoreUtils.isNullOrEmpty(metadata)) {
            StringBuilder sb = new StringBuilder();
            boolean firstMetadata = true;
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                if (Objects.isNull(entry.getKey()) || entry.getKey().isEmpty()) {
                    throw new IllegalArgumentException("The key for one of the metadata key-value pairs is null, empty, or whitespace.");
                }
                if (Objects.isNull(entry.getValue()) || entry.getValue().isEmpty()) {
                    throw new IllegalArgumentException("The value for one of the metadata key-value pairs is null, empty, or whitespace.");
                }
                if (!firstMetadata) {
                    sb.append(',');
                }
                sb.append(entry.getKey()).append('=').append(new String(Base64.getEncoder().encode(entry.getValue().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                firstMetadata = false;
            }
            return sb.toString();
        }
        return null;
    }

    public static DataLakeStorageException mapToDataLakeStorageException(DataLakeStorageExceptionInternal internal) {
        return new DataLakeStorageException(internal.getMessage(), internal.getResponse(), internal.getValue());
    }

    public static PathSystemProperties getSystemPropertiesResponse(ResponseBase<PathsGetPropertiesHeaders, Void> response) {
        PathsGetPropertiesHeaders headers = (PathsGetPropertiesHeaders)response.getDeserializedHeaders();
        OffsetDateTime creationTime = headers.getXMsCreationTime();
        OffsetDateTime lastModified = headers.getLastModified();
        String eTag = headers.getETag();
        Long fileSize = headers.getContentLength();
        Boolean isDirectory = Objects.equals(headers.getXMsResourceType(), "directory");
        Boolean isServerEncrypted = headers.isXMsServerEncrypted();
        String encryptionKeySha256 = headers.getXMsEncryptionKeySha256();
        OffsetDateTime expiresOn = headers.getXMsExpiryTime();
        String encryptionScope = headers.getXMsEncryptionScope();
        String encryptionContext = headers.getXMsEncryptionContext();
        String owner = headers.getXMsOwner();
        String group = headers.getXMsGroup();
        String permissions = headers.getXMsPermissions();
        PathPermissions parsedPermissions = permissions != null ? PathPermissions.parseSymbolic(permissions) : null;
        return AccessorUtility.create(creationTime, lastModified, eTag, fileSize, isDirectory, isServerEncrypted, encryptionKeySha256, expiresOn, encryptionScope, encryptionContext, owner, group, parsedPermissions);
    }
}

