/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.dboe.base.file.BinaryDataFile;

public class BinaryDataFileRandomAccess
implements BinaryDataFile {
    protected RandomAccessFile file;
    protected boolean readMode;
    protected long readPosition;
    protected long writePosition;
    private final String filename;

    public BinaryDataFileRandomAccess(String filename) {
        this.filename = filename;
    }

    @Override
    public void open() {
        if (this.file != null) {
            throw new RuntimeIOException("Already open");
        }
        try {
            this.file = new RandomAccessFile(this.filename, "rw");
            this.writePosition = this.file.length();
            this.readPosition = 0L;
            this.readMode = true;
        }
        catch (IOException e) {
            IO.exception((IOException)e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.file != null;
    }

    @Override
    public int read(long posn, byte[] b, int start, int length) {
        this.checkOpen();
        this.switchToReadMode();
        this.seek(posn);
        try {
            int x = this.file.read(b, start, length);
            this.readPosition += (long)x;
            return x;
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return -1;
        }
    }

    @Override
    public long write(byte[] b, int start, int length) {
        this.checkOpen();
        this.switchToWriteMode();
        long x = this.writePosition;
        try {
            this.file.write(b, start, length);
            this.writePosition += (long)length;
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
        return x;
    }

    private void seek(long posn) {
        try {
            this.file.seek(posn);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    @Override
    public void truncate(long length) {
        this.checkOpen();
        this.switchToWriteMode();
        try {
            this.file.setLength(length);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    @Override
    public void sync() {
        this.checkOpen();
        this.flush$();
    }

    protected void flush$() {
        try {
            this.file.getFD().sync();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.file.close();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
        this.file = null;
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return -1L;
        }
    }

    protected void switchToReadMode() {
        if (!this.readMode) {
            this.readMode = true;
        }
    }

    protected void switchToWriteMode() {
        if (this.readMode) {
            this.readMode = false;
            this.seek(this.writePosition);
        }
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new RuntimeIOException("Not open");
        }
    }
}

