/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleBase;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.Abortable;
import org.apache.jena.sparql.engine.iterator.QueryIterAbortable;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.solver.BindingNodeId;
import org.apache.jena.tdb2.solver.SolverLibTDB;
import org.apache.jena.tdb2.solver.SolverRX;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.GraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class PatternMatchTDB2 {
    public static QueryIterator execute(GraphTDB graph, BasicPattern pattern, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTupleTable ntt = graph.getNodeTupleTable();
        return PatternMatchTDB2.execute(ntt, graph.getGraphName(), pattern, input, filter, execCxt);
    }

    public static QueryIterator execute(DatasetGraphTDB ds, Node graphNode, BasicPattern pattern, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTupleTable ntt = ds.chooseNodeTupleTable(graphNode);
        return PatternMatchTDB2.execute(ntt, graphNode, pattern, input, filter, execCxt);
    }

    private static QueryIterator execute(NodeTupleTable nodeTupleTable, Node graphNode, BasicPattern pattern, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        if (Quad.isUnionGraph(graphNode)) {
            graphNode = Node.ANY;
        }
        if (Quad.isDefaultGraph(graphNode)) {
            graphNode = null;
        }
        List<Triple> triples = pattern.getList();
        boolean anyGraph = graphNode == null ? false : Node.ANY.equals(graphNode);
        int tupleLen = nodeTupleTable.getTupleTable().getTupleLen();
        if (graphNode == null) {
            if (3 != tupleLen) {
                throw new TDBException("SolverLib: Null graph node but tuples are of length " + tupleLen);
            }
        } else if (4 != tupleLen) {
            throw new TDBException("SolverLib: Graph node specified but tuples are of length " + tupleLen);
        }
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Iterator<BindingNodeId> chain = Iter.map(input, SolverLibTDB.convFromBinding(nodeTable));
        ArrayList<Abortable> killList = new ArrayList<Abortable>();
        for (Triple triple : triples) {
            TupleBase patternTuple = null;
            patternTuple = graphNode == null ? TupleFactory.create3(triple.getSubject(), triple.getPredicate(), triple.getObject()) : TupleFactory.create4(graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
            chain = PatternMatchTDB2.matchQuadPattern(chain, graphNode, triple, nodeTupleTable, patternTuple, anyGraph, filter, execCxt);
            chain = SolverLib.makeAbortable(chain, killList);
        }
        Iterator<Binding> iterBinding = SolverLibTDB.convertToNodes(chain, nodeTable);
        return new QueryIterAbortable(iterBinding, killList, input, execCxt);
    }

    private static Iterator<BindingNodeId> matchQuadPattern(Iterator<BindingNodeId> chain, Node graphNode, Triple tPattern, NodeTupleTable nodeTupleTable, Tuple<Node> patternTuple, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        return SolverRX.matchQuadPattern(chain, graphNode, tPattern, nodeTupleTable, patternTuple, anyGraph, filter, execCxt);
    }
}

