/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import java.util.concurrent.TimeUnit;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecDatasetBuilder;
import org.apache.jena.sparql.exec.UpdateExecutionAdapter;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecutionDatasetBuilder
implements UpdateExecutionBuilder {
    private final UpdateExecDatasetBuilder builder = UpdateExec.newBuilder();

    public static UpdateExecutionDatasetBuilder newBuilder() {
        return new UpdateExecutionDatasetBuilder();
    }

    public static UpdateExecutionDatasetBuilder create() {
        return UpdateExecutionDatasetBuilder.newBuilder();
    }

    @Override
    public UpdateExecutionDatasetBuilder update(UpdateRequest updateRequest) {
        this.builder.update(updateRequest);
        return this;
    }

    @Override
    public UpdateExecutionDatasetBuilder update(Update update2) {
        this.builder.update(update2);
        return this;
    }

    @Override
    public UpdateExecutionDatasetBuilder update(String updateRequestString) {
        this.builder.update(updateRequestString);
        return this;
    }

    @Override
    public UpdateExecutionBuilder parseCheck(boolean parseCheck) {
        this.builder.parseCheck(parseCheck);
        return this;
    }

    public UpdateExecutionDatasetBuilder dataset(Dataset dataset) {
        this.builder.dataset(dataset.asDatasetGraph());
        return this;
    }

    @Override
    public UpdateExecutionDatasetBuilder set(Symbol symbol, Object value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public UpdateExecutionDatasetBuilder set(Symbol symbol, boolean value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public UpdateExecutionDatasetBuilder context(Context context2) {
        this.builder.context(context2);
        return this;
    }

    @Deprecated(forRemoval=true)
    public UpdateExecutionDatasetBuilder initialBinding(QuerySolution querySolution) {
        if (querySolution == null) {
            return this;
        }
        Binding binding = BindingLib.asBinding(querySolution);
        this.builder.initialBinding(binding);
        return this;
    }

    @Override
    public UpdateExecutionDatasetBuilder substitution(QuerySolution querySolution) {
        if (querySolution == null) {
            return this;
        }
        Binding binding = BindingLib.asBinding(querySolution);
        this.builder.substitution(binding);
        return this;
    }

    @Override
    public UpdateExecutionDatasetBuilder substitution(String varName, RDFNode value) {
        Var var = Var.alloc(varName);
        Node val = value.asNode();
        this.builder.substitution(var, val);
        return this;
    }

    @Override
    public UpdateExecutionBuilder timeout(long value, TimeUnit timeUnit) {
        this.builder.timeout(value, timeUnit);
        return this;
    }

    @Override
    public UpdateExecution build() {
        UpdateExec exec = this.builder.build();
        return UpdateExecutionAdapter.adapt(exec);
    }

    @Override
    public void execute() {
        this.build().execute();
    }

    public void execute(Dataset dataset) {
        this.dataset(dataset);
        this.execute();
    }
}

