/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.OptionalLong;
import java.util.function.UnaryOperator;
import org.apache.kafka.common.utils.ExponentialBackoff;

public class AssignmentsManagerDeadlineFunction
implements UnaryOperator<OptionalLong> {
    private final ExponentialBackoff backoff;
    private final long nowNs;
    private final int previousGlobalFailures;
    private final boolean hasInflightRequests;
    private final int numReadyRequests;

    AssignmentsManagerDeadlineFunction(ExponentialBackoff backoff, long nowNs, int previousGlobalFailures, boolean hasInflightRequests, int numReadyRequests) {
        this.backoff = backoff;
        this.nowNs = nowNs;
        this.previousGlobalFailures = previousGlobalFailures;
        this.hasInflightRequests = hasInflightRequests;
        this.numReadyRequests = numReadyRequests;
    }

    @Override
    public OptionalLong apply(OptionalLong previousSendTimeNs) {
        long delayNs = this.previousGlobalFailures > 0 ? this.backoff.backoff((long)this.previousGlobalFailures) : (this.numReadyRequests > 2250 && !this.hasInflightRequests ? 0L : this.backoff.initialInterval());
        long newSendTimeNs = this.nowNs + delayNs;
        if (previousSendTimeNs.isPresent() && previousSendTimeNs.getAsLong() < newSendTimeNs) {
            return previousSendTimeNs;
        }
        return OptionalLong.of(newSendTimeNs);
    }
}

