/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto.random;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.kerby.kerberos.kerb.crypto.random.RandomProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeRandom
implements RandomProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NativeRandom.class);
    private InputStream input;
    private String randFile = "/dev/urandom";

    @Override
    public void init() {
        try {
            this.input = Files.newInputStream(Paths.get(this.randFile, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.error("Failed to init from file: " + this.randFile + ". " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeed(byte[] seed) {
        OutputStream output = null;
        try {
            output = Files.newOutputStream(Paths.get(this.randFile, new String[0]), new OpenOption[0]);
            output.write(seed);
            output.flush();
        }
        catch (IOException e) {
            LOG.error("Failed to write seed to the file: " + this.randFile + ". " + e.toString());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close output stream. " + e.toString());
                }
            }
        }
    }

    @Override
    public void nextBytes(byte[] bytes) {
        try {
            if (this.input.read(bytes) == -1) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read nextBytes. " + e.toString());
        }
    }

    @Override
    public void destroy() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close input stream. " + e.toString());
        }
    }
}

