/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.core.CacheConfigurationChangeEvent;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.CacheConfigurationProperty;
import org.ehcache.core.HumanReadable;
import org.ehcache.core.InternalRuntimeConfiguration;
import org.ehcache.core.internal.events.EventListenerWrapper;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.expiry.Expiry;
import org.ehcache.spi.service.ServiceConfiguration;

class EhcacheRuntimeConfiguration<K, V>
implements CacheRuntimeConfiguration<K, V>,
InternalRuntimeConfiguration,
HumanReadable {
    private final Collection<ServiceConfiguration<?>> serviceConfigurations;
    private final CacheConfiguration<? super K, ? super V> config;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final ClassLoader classLoader;
    private final Expiry<? super K, ? super V> expiry;
    private volatile ResourcePools resourcePools;
    private final List<CacheConfigurationChangeListener> cacheConfigurationListenerList = new CopyOnWriteArrayList<CacheConfigurationChangeListener>();

    EhcacheRuntimeConfiguration(CacheConfiguration<K, V> config) {
        this.config = config;
        this.serviceConfigurations = this.copy(config.getServiceConfigurations());
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.evictionAdvisor = config.getEvictionAdvisor();
        this.classLoader = config.getClassLoader();
        this.expiry = config.getExpiry();
        this.resourcePools = config.getResourcePools();
    }

    @Override
    public synchronized void updateResourcePools(ResourcePools pools) {
        if (pools == null) {
            throw new NullPointerException("Pools to be updated cannot be null");
        }
        ResourcePools updatedResourcePools = this.config.getResourcePools().validateAndMerge(pools);
        this.fireCacheConfigurationChange(CacheConfigurationProperty.UPDATE_SIZE, this.config.getResourcePools(), updatedResourcePools);
        this.resourcePools = updatedResourcePools;
    }

    @Override
    public Collection<ServiceConfiguration<?>> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public EvictionAdvisor<? super K, ? super V> getEvictionAdvisor() {
        return this.evictionAdvisor;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Expiry<? super K, ? super V> getExpiry() {
        return this.expiry;
    }

    @Override
    public ResourcePools getResourcePools() {
        return this.resourcePools;
    }

    @Override
    public boolean addCacheConfigurationListener(List<CacheConfigurationChangeListener> listeners) {
        return this.cacheConfigurationListenerList.addAll(listeners);
    }

    @Override
    public boolean removeCacheConfigurationListener(CacheConfigurationChangeListener listener) {
        return this.cacheConfigurationListenerList.remove(listener);
    }

    @Override
    public synchronized void deregisterCacheEventListener(CacheEventListener<? super K, ? super V> listener) {
        this.fireCacheConfigurationChange(CacheConfigurationProperty.REMOVE_LISTENER, listener, listener);
    }

    @Override
    public synchronized void registerCacheEventListener(CacheEventListener<? super K, ? super V> listener, EventOrdering ordering, EventFiring firing, Set<EventType> forEventTypes) {
        EventListenerWrapper<? super K, ? super V> listenerWrapper = new EventListenerWrapper<K, V>(listener, firing, ordering, EnumSet.copyOf(forEventTypes));
        this.fireCacheConfigurationChange(CacheConfigurationProperty.ADD_LISTENER, listenerWrapper, listenerWrapper);
    }

    @Override
    public void registerCacheEventListener(CacheEventListener<? super K, ? super V> listener, EventOrdering ordering, EventFiring firing, EventType eventType, EventType ... eventTypes) {
        EventListenerWrapper<? super K, ? super V> listenerWrapper = new EventListenerWrapper<K, V>(listener, firing, ordering, EnumSet.of(eventType, eventTypes));
        this.fireCacheConfigurationChange(CacheConfigurationProperty.ADD_LISTENER, listenerWrapper, listenerWrapper);
    }

    private <T> Collection<T> copy(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return Collections.unmodifiableCollection(new ArrayList<T>(collection));
    }

    private <T> void fireCacheConfigurationChange(CacheConfigurationProperty prop, T oldValue, T newValue) {
        if (oldValue != null && !oldValue.equals(newValue) || newValue != null) {
            for (CacheConfigurationChangeListener cacheConfigurationListener : this.cacheConfigurationListenerList) {
                cacheConfigurationListener.cacheConfigurationChange(new CacheConfigurationChangeEvent(prop, oldValue, newValue));
            }
        }
    }

    @Override
    public String readableString() {
        StringBuilder serviceConfigurationsToStringBuilder = new StringBuilder();
        for (ServiceConfiguration<?> serviceConfiguration : this.serviceConfigurations) {
            serviceConfigurationsToStringBuilder.append("\n    ").append("- ");
            if (serviceConfiguration instanceof HumanReadable) {
                serviceConfigurationsToStringBuilder.append(((HumanReadable)((Object)serviceConfiguration)).readableString()).append("\n");
                continue;
            }
            serviceConfigurationsToStringBuilder.append(serviceConfiguration.getClass().getName()).append("\n");
        }
        if (serviceConfigurationsToStringBuilder.length() > 0) {
            serviceConfigurationsToStringBuilder.deleteCharAt(serviceConfigurationsToStringBuilder.length() - 1);
        } else {
            serviceConfigurationsToStringBuilder.append(" None");
        }
        return "keyType: " + this.keyType.getName() + "\n" + "valueType: " + this.valueType.getName() + "\n" + "serviceConfigurations:" + serviceConfigurationsToStringBuilder.toString().replace("\n", "\n    ") + "\n" + "evictionAdvisor: " + (this.evictionAdvisor != null ? this.evictionAdvisor.getClass().getName() : "None") + "\n" + "expiry: " + (this.expiry != null ? this.expiry.getClass().getSimpleName() : "") + "\n" + "resourcePools: " + "\n    " + (this.resourcePools instanceof HumanReadable ? ((HumanReadable)((Object)this.resourcePools)).readableString() : "").replace("\n", "\n    ");
    }
}

