/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiOzoneSnapshotDetails;
import com.cloudera.api.swagger.model.ApiOzoneSnapshotError;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Detailed information about an Ozone snapshot command.")
public class ApiOzoneSnapshotResult {
    @SerializedName(value="processedBucketCount")
    private BigDecimal processedBucketCount = null;
    @SerializedName(value="processedBuckets")
    private List<String> processedBuckets = null;
    @SerializedName(value="unprocessedBucketCount")
    private BigDecimal unprocessedBucketCount = null;
    @SerializedName(value="unprocessedBuckets")
    private List<String> unprocessedBuckets = null;
    @SerializedName(value="createdSnapshotCount")
    private BigDecimal createdSnapshotCount = null;
    @SerializedName(value="createdSnapshots")
    private List<ApiOzoneSnapshotDetails> createdSnapshots = null;
    @SerializedName(value="deletedSnapshotCount")
    private BigDecimal deletedSnapshotCount = null;
    @SerializedName(value="deletedSnapshots")
    private List<ApiOzoneSnapshotDetails> deletedSnapshots = null;
    @SerializedName(value="creationErrorCount")
    private BigDecimal creationErrorCount = null;
    @SerializedName(value="creationErrors")
    private List<ApiOzoneSnapshotError> creationErrors = null;
    @SerializedName(value="deletionErrorCount")
    private BigDecimal deletionErrorCount = null;
    @SerializedName(value="deletionErrors")
    private List<ApiOzoneSnapshotError> deletionErrors = null;

    public ApiOzoneSnapshotResult processedBucketCount(BigDecimal processedBucketCount) {
        this.processedBucketCount = processedBucketCount;
        return this;
    }

    @Schema(description="Number of processed paths.")
    public BigDecimal getProcessedBucketCount() {
        return this.processedBucketCount;
    }

    public void setProcessedBucketCount(BigDecimal processedBucketCount) {
        this.processedBucketCount = processedBucketCount;
    }

    public ApiOzoneSnapshotResult processedBuckets(List<String> processedBuckets) {
        this.processedBuckets = processedBuckets;
        return this;
    }

    public ApiOzoneSnapshotResult addProcessedBucketsItem(String processedBucketsItem) {
        if (this.processedBuckets == null) {
            this.processedBuckets = new ArrayList<String>();
        }
        this.processedBuckets.add(processedBucketsItem);
        return this;
    }

    @Schema(description="The list of processed paths.  This is only available in the full view.")
    public List<String> getProcessedBuckets() {
        return this.processedBuckets;
    }

    public void setProcessedBuckets(List<String> processedBuckets) {
        this.processedBuckets = processedBuckets;
    }

    public ApiOzoneSnapshotResult unprocessedBucketCount(BigDecimal unprocessedBucketCount) {
        this.unprocessedBucketCount = unprocessedBucketCount;
        return this;
    }

    @Schema(description="Number of unprocessed paths.")
    public BigDecimal getUnprocessedBucketCount() {
        return this.unprocessedBucketCount;
    }

    public void setUnprocessedBucketCount(BigDecimal unprocessedBucketCount) {
        this.unprocessedBucketCount = unprocessedBucketCount;
    }

    public ApiOzoneSnapshotResult unprocessedBuckets(List<String> unprocessedBuckets) {
        this.unprocessedBuckets = unprocessedBuckets;
        return this;
    }

    public ApiOzoneSnapshotResult addUnprocessedBucketsItem(String unprocessedBucketsItem) {
        if (this.unprocessedBuckets == null) {
            this.unprocessedBuckets = new ArrayList<String>();
        }
        this.unprocessedBuckets.add(unprocessedBucketsItem);
        return this;
    }

    @Schema(description="The list of unprocessed paths. Note that paths that are currently being processed will also be included in this list.  This is only available in the full view.")
    public List<String> getUnprocessedBuckets() {
        return this.unprocessedBuckets;
    }

    public void setUnprocessedBuckets(List<String> unprocessedBuckets) {
        this.unprocessedBuckets = unprocessedBuckets;
    }

    public ApiOzoneSnapshotResult createdSnapshotCount(BigDecimal createdSnapshotCount) {
        this.createdSnapshotCount = createdSnapshotCount;
        return this;
    }

    @Schema(description="Number of snapshots created.")
    public BigDecimal getCreatedSnapshotCount() {
        return this.createdSnapshotCount;
    }

    public void setCreatedSnapshotCount(BigDecimal createdSnapshotCount) {
        this.createdSnapshotCount = createdSnapshotCount;
    }

    public ApiOzoneSnapshotResult createdSnapshots(List<ApiOzoneSnapshotDetails> createdSnapshots) {
        this.createdSnapshots = createdSnapshots;
        return this;
    }

    public ApiOzoneSnapshotResult addCreatedSnapshotsItem(ApiOzoneSnapshotDetails createdSnapshotsItem) {
        if (this.createdSnapshots == null) {
            this.createdSnapshots = new ArrayList<ApiOzoneSnapshotDetails>();
        }
        this.createdSnapshots.add(createdSnapshotsItem);
        return this;
    }

    @Schema(description="List of snapshots created. <p/> This is only available in the full view.")
    public List<ApiOzoneSnapshotDetails> getCreatedSnapshots() {
        return this.createdSnapshots;
    }

    public void setCreatedSnapshots(List<ApiOzoneSnapshotDetails> createdSnapshots) {
        this.createdSnapshots = createdSnapshots;
    }

    public ApiOzoneSnapshotResult deletedSnapshotCount(BigDecimal deletedSnapshotCount) {
        this.deletedSnapshotCount = deletedSnapshotCount;
        return this;
    }

    @Schema(description="Number of snapshots deleted.")
    public BigDecimal getDeletedSnapshotCount() {
        return this.deletedSnapshotCount;
    }

    public void setDeletedSnapshotCount(BigDecimal deletedSnapshotCount) {
        this.deletedSnapshotCount = deletedSnapshotCount;
    }

    public ApiOzoneSnapshotResult deletedSnapshots(List<ApiOzoneSnapshotDetails> deletedSnapshots) {
        this.deletedSnapshots = deletedSnapshots;
        return this;
    }

    public ApiOzoneSnapshotResult addDeletedSnapshotsItem(ApiOzoneSnapshotDetails deletedSnapshotsItem) {
        if (this.deletedSnapshots == null) {
            this.deletedSnapshots = new ArrayList<ApiOzoneSnapshotDetails>();
        }
        this.deletedSnapshots.add(deletedSnapshotsItem);
        return this;
    }

    @Schema(description="List of snapshots deleted.  This is only available in the full view.")
    public List<ApiOzoneSnapshotDetails> getDeletedSnapshots() {
        return this.deletedSnapshots;
    }

    public void setDeletedSnapshots(List<ApiOzoneSnapshotDetails> deletedSnapshots) {
        this.deletedSnapshots = deletedSnapshots;
    }

    public ApiOzoneSnapshotResult creationErrorCount(BigDecimal creationErrorCount) {
        this.creationErrorCount = creationErrorCount;
        return this;
    }

    @Schema(description="Number of errors detected when creating snapshots.")
    public BigDecimal getCreationErrorCount() {
        return this.creationErrorCount;
    }

    public void setCreationErrorCount(BigDecimal creationErrorCount) {
        this.creationErrorCount = creationErrorCount;
    }

    public ApiOzoneSnapshotResult creationErrors(List<ApiOzoneSnapshotError> creationErrors) {
        this.creationErrors = creationErrors;
        return this;
    }

    public ApiOzoneSnapshotResult addCreationErrorsItem(ApiOzoneSnapshotError creationErrorsItem) {
        if (this.creationErrors == null) {
            this.creationErrors = new ArrayList<ApiOzoneSnapshotError>();
        }
        this.creationErrors.add(creationErrorsItem);
        return this;
    }

    @Schema(description="List of errors encountered when creating snapshots.  This is only available in the full view.")
    public List<ApiOzoneSnapshotError> getCreationErrors() {
        return this.creationErrors;
    }

    public void setCreationErrors(List<ApiOzoneSnapshotError> creationErrors) {
        this.creationErrors = creationErrors;
    }

    public ApiOzoneSnapshotResult deletionErrorCount(BigDecimal deletionErrorCount) {
        this.deletionErrorCount = deletionErrorCount;
        return this;
    }

    @Schema(description="Number of errors detected when deleting snapshots.")
    public BigDecimal getDeletionErrorCount() {
        return this.deletionErrorCount;
    }

    public void setDeletionErrorCount(BigDecimal deletionErrorCount) {
        this.deletionErrorCount = deletionErrorCount;
    }

    public ApiOzoneSnapshotResult deletionErrors(List<ApiOzoneSnapshotError> deletionErrors) {
        this.deletionErrors = deletionErrors;
        return this;
    }

    public ApiOzoneSnapshotResult addDeletionErrorsItem(ApiOzoneSnapshotError deletionErrorsItem) {
        if (this.deletionErrors == null) {
            this.deletionErrors = new ArrayList<ApiOzoneSnapshotError>();
        }
        this.deletionErrors.add(deletionErrorsItem);
        return this;
    }

    @Schema(description="List of errors encountered when deleting snapshots.  This is only available in the full view.")
    public List<ApiOzoneSnapshotError> getDeletionErrors() {
        return this.deletionErrors;
    }

    public void setDeletionErrors(List<ApiOzoneSnapshotError> deletionErrors) {
        this.deletionErrors = deletionErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiOzoneSnapshotResult apiOzoneSnapshotResult = (ApiOzoneSnapshotResult)o;
        return Objects.equals(this.processedBucketCount, apiOzoneSnapshotResult.processedBucketCount) && Objects.equals(this.processedBuckets, apiOzoneSnapshotResult.processedBuckets) && Objects.equals(this.unprocessedBucketCount, apiOzoneSnapshotResult.unprocessedBucketCount) && Objects.equals(this.unprocessedBuckets, apiOzoneSnapshotResult.unprocessedBuckets) && Objects.equals(this.createdSnapshotCount, apiOzoneSnapshotResult.createdSnapshotCount) && Objects.equals(this.createdSnapshots, apiOzoneSnapshotResult.createdSnapshots) && Objects.equals(this.deletedSnapshotCount, apiOzoneSnapshotResult.deletedSnapshotCount) && Objects.equals(this.deletedSnapshots, apiOzoneSnapshotResult.deletedSnapshots) && Objects.equals(this.creationErrorCount, apiOzoneSnapshotResult.creationErrorCount) && Objects.equals(this.creationErrors, apiOzoneSnapshotResult.creationErrors) && Objects.equals(this.deletionErrorCount, apiOzoneSnapshotResult.deletionErrorCount) && Objects.equals(this.deletionErrors, apiOzoneSnapshotResult.deletionErrors);
    }

    public int hashCode() {
        return Objects.hash(this.processedBucketCount, this.processedBuckets, this.unprocessedBucketCount, this.unprocessedBuckets, this.createdSnapshotCount, this.createdSnapshots, this.deletedSnapshotCount, this.deletedSnapshots, this.creationErrorCount, this.creationErrors, this.deletionErrorCount, this.deletionErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiOzoneSnapshotResult {\n");
        sb.append("    processedBucketCount: ").append(this.toIndentedString(this.processedBucketCount)).append("\n");
        sb.append("    processedBuckets: ").append(this.toIndentedString(this.processedBuckets)).append("\n");
        sb.append("    unprocessedBucketCount: ").append(this.toIndentedString(this.unprocessedBucketCount)).append("\n");
        sb.append("    unprocessedBuckets: ").append(this.toIndentedString(this.unprocessedBuckets)).append("\n");
        sb.append("    createdSnapshotCount: ").append(this.toIndentedString(this.createdSnapshotCount)).append("\n");
        sb.append("    createdSnapshots: ").append(this.toIndentedString(this.createdSnapshots)).append("\n");
        sb.append("    deletedSnapshotCount: ").append(this.toIndentedString(this.deletedSnapshotCount)).append("\n");
        sb.append("    deletedSnapshots: ").append(this.toIndentedString(this.deletedSnapshots)).append("\n");
        sb.append("    creationErrorCount: ").append(this.toIndentedString(this.creationErrorCount)).append("\n");
        sb.append("    creationErrors: ").append(this.toIndentedString(this.creationErrors)).append("\n");
        sb.append("    deletionErrorCount: ").append(this.toIndentedString(this.deletionErrorCount)).append("\n");
        sb.append("    deletionErrors: ").append(this.toIndentedString(this.deletionErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

