/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.urlconnection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import zipkin2.reporter.BaseHttpSender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

final class InternalURLConnectionSender
extends BaseHttpSender<URL, byte[]> {
    final int messageMaxBytes;
    final int connectTimeout;
    final int readTimeout;
    final boolean compressionEnabled;

    InternalURLConnectionSender(URLConnectionSender.Builder builder) {
        super(builder.encoding, builder.endpointSupplierFactory, builder.endpoint);
        this.messageMaxBytes = builder.messageMaxBytes;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.compressionEnabled = builder.compressionEnabled;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    protected URL newEndpoint(String endpoint) {
        try {
            return new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected byte[] newBody(List<byte[]> encodedSpans) {
        return this.encoding.encode(encodedSpans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postSpans(URL endpoint, byte[] body) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod("POST");
        connection.addRequestProperty("b3", "0");
        connection.addRequestProperty("Content-Type", this.encoding.mediaType());
        if (this.compressionEnabled) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            GZIPOutputStream compressor = new GZIPOutputStream(gzipped);
            try {
                compressor.write(body);
            }
            finally {
                compressor.close();
            }
            body = gzipped.toByteArray();
        }
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(body.length);
        connection.getOutputStream().write(body);
        InternalURLConnectionSender.skipAllContent(connection);
    }

    static void skipAllContent(HttpURLConnection connection) throws IOException {
        InputStream in = connection.getInputStream();
        IOException thrown = InternalURLConnectionSender.skipAndSuppress(in);
        if (thrown == null) {
            return;
        }
        InputStream err = connection.getErrorStream();
        if (err != null) {
            InternalURLConnectionSender.skipAndSuppress(err);
        }
        throw thrown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IOException skipAndSuppress(InputStream in) {
        try {
            while (in.read() != -1) {
            }
            IOException iOException = null;
            return iOException;
        }
        catch (IOException e) {
            IOException iOException = e;
            return iOException;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return super.toString().replace("Internal", "");
    }
}

