/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.constraint.DefaultConstraints;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.util.InternationalString;

@XmlType(name="MD_LegalConstraints_Type", propOrder={"accessConstraints", "useConstraints", "otherConstraints"})
@XmlRootElement(name="MD_LegalConstraints")
public class DefaultLegalConstraints
extends DefaultConstraints
implements LegalConstraints {
    private static final long serialVersionUID = -228007779747439839L;
    private Collection<Restriction> accessConstraints;
    private Collection<Restriction> useConstraints;
    private Collection<InternationalString> otherConstraints;

    public DefaultLegalConstraints() {
    }

    public DefaultLegalConstraints(CharSequence useLimitation) {
        super(useLimitation);
    }

    public DefaultLegalConstraints(LegalConstraints object) {
        super((Constraints)object);
        if (object != null) {
            this.accessConstraints = DefaultLegalConstraints.copyCollection(object.getAccessConstraints(), Restriction.class);
            this.useConstraints = DefaultLegalConstraints.copyCollection(object.getUseConstraints(), Restriction.class);
            this.otherConstraints = DefaultLegalConstraints.copyCollection(object.getOtherConstraints(), InternationalString.class);
        }
    }

    public static DefaultLegalConstraints castOrCopy(LegalConstraints object) {
        if (object == null || object instanceof DefaultLegalConstraints) {
            return (DefaultLegalConstraints)object;
        }
        return new DefaultLegalConstraints(object);
    }

    @XmlElement(name="accessConstraints")
    public Collection<Restriction> getAccessConstraints() {
        this.accessConstraints = this.nonNullCollection(this.accessConstraints, Restriction.class);
        return this.accessConstraints;
    }

    public void setAccessConstraints(Collection<? extends Restriction> newValues) {
        this.accessConstraints = this.writeCollection(newValues, this.accessConstraints, Restriction.class);
    }

    @XmlElement(name="useConstraints")
    public Collection<Restriction> getUseConstraints() {
        this.useConstraints = this.nonNullCollection(this.useConstraints, Restriction.class);
        return this.useConstraints;
    }

    public void setUseConstraints(Collection<? extends Restriction> newValues) {
        this.useConstraints = this.writeCollection(newValues, this.useConstraints, Restriction.class);
    }

    @XmlElement(name="otherConstraints")
    public Collection<InternationalString> getOtherConstraints() {
        this.otherConstraints = this.nonNullCollection(this.otherConstraints, InternationalString.class);
        return this.otherConstraints;
    }

    public void setOtherConstraints(Collection<? extends InternationalString> newValues) {
        this.otherConstraints = this.writeCollection(newValues, this.otherConstraints, InternationalString.class);
    }
}

