/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.pprof.parser;

import com.google.perftools.profiles.ProfileProto;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofParser;

public class PprofSegmentParser {
    public static List<SegmentInfo> parseSegments(ProfileProto.Profile profile) {
        ProtocolStringList stringTable = profile.getStringTableList();
        HashMap<String, List> segmentSamples = new HashMap<String, List>();
        for (ProfileProto.Sample sample2 : profile.getSampleList()) {
            String segmentId = PprofSegmentParser.extractSegmentIdFromLabels(sample2.getLabelList(), (List<String>)stringTable);
            if (segmentId == null) continue;
            segmentSamples.computeIfAbsent(segmentId, k -> new ArrayList()).add(sample2);
        }
        ArrayList<SegmentInfo> result = new ArrayList<SegmentInfo>(segmentSamples.size());
        for (Map.Entry entry : segmentSamples.entrySet()) {
            String segmentId = (String)entry.getKey();
            List samples = (List)entry.getValue();
            SegmentInfo segmentInfo = new SegmentInfo();
            segmentInfo.setSegmentId(segmentId);
            ProfileProto.Sample firstSample = (ProfileProto.Sample)samples.get(0);
            segmentInfo.setTraceId(PprofSegmentParser.extractTraceIdFromLabels(firstSample.getLabelList(), (List<String>)stringTable));
            segmentInfo.setSpanId(PprofSegmentParser.extractSpanIdFromLabels(firstSample.getLabelList(), (List<String>)stringTable));
            segmentInfo.setServiceInstanceId(PprofSegmentParser.extractServiceInstanceIdFromLabels(firstSample.getLabelList(), (List<String>)stringTable));
            List<String> combinedStack = PprofSegmentParser.extractCombinedStackFromSamples(samples, profile);
            segmentInfo.setStack(combinedStack);
            long totalCount = samples.stream().mapToLong(sample -> sample.getValueCount() > 0 ? sample.getValue(0) : 1L).sum();
            segmentInfo.setCount(totalCount);
            result.add(segmentInfo);
        }
        return result;
    }

    public static String extractSegmentIdFromLabels(List<ProfileProto.Label> labels, List<String> stringTable) {
        for (ProfileProto.Label label : labels) {
            String key = PprofSegmentParser.getStringFromTable(label.getKey(), stringTable);
            if (key == null || !key.equals("segment_id") && !key.equals("trace_segment_id") && !key.equals("segmentId") && !key.equals("traceSegmentId") && !key.equals("traceSegmentID")) continue;
            return PprofSegmentParser.getStringFromTable(label.getStr(), stringTable);
        }
        return null;
    }

    private static String extractTraceIdFromLabels(List<ProfileProto.Label> labels, List<String> stringTable) {
        for (ProfileProto.Label label : labels) {
            String key = PprofSegmentParser.getStringFromTable(label.getKey(), stringTable);
            if (key == null || !key.equals("trace_id") && !key.equals("traceId") && !key.equals("traceID")) continue;
            return PprofSegmentParser.getStringFromTable(label.getStr(), stringTable);
        }
        return "go_trace_" + UUID.randomUUID().toString().replace("-", "");
    }

    private static String extractSpanIdFromLabels(List<ProfileProto.Label> labels, List<String> stringTable) {
        for (ProfileProto.Label label : labels) {
            String key = PprofSegmentParser.getStringFromTable(label.getKey(), stringTable);
            if (key == null || !key.equals("span_id") && !key.equals("spanId") && !key.equals("spanID")) continue;
            return PprofSegmentParser.getStringFromTable(label.getStr(), stringTable);
        }
        return null;
    }

    private static String extractServiceInstanceIdFromLabels(List<ProfileProto.Label> labels, List<String> stringTable) {
        for (ProfileProto.Label label : labels) {
            String key = PprofSegmentParser.getStringFromTable(label.getKey(), stringTable);
            if (key == null || !key.equals("service_instance_id") && !key.equals("serviceInstanceId") && !key.equals("instance_id") && !key.equals("instanceId")) continue;
            return PprofSegmentParser.getStringFromTable(label.getStr(), stringTable);
        }
        return "go_instance_1";
    }

    private static List<String> extractCombinedStackFromSamples(List<ProfileProto.Sample> samples, ProfileProto.Profile profile) {
        LinkedHashSet<String> uniqueStack = new LinkedHashSet<String>();
        for (ProfileProto.Sample sample : samples) {
            List<String> stack = PprofSegmentParser.extractStackFromSample(sample, profile);
            uniqueStack.addAll(stack);
        }
        return new ArrayList<String>(uniqueStack);
    }

    public static List<String> extractStackFromSample(ProfileProto.Sample sample, ProfileProto.Profile profile) {
        ArrayList<String> stack = new ArrayList<String>();
        for (int i = sample.getLocationIdCount() - 1; i >= 0; --i) {
            long locationId = sample.getLocationId(i);
            String signature = PprofParser.resolveSignature(locationId, profile);
            if (signature == null || signature.isEmpty()) continue;
            stack.add(signature);
        }
        return stack;
    }

    public static String getStringFromTable(long index, List<String> stringTable) {
        if (index >= 0L && index < (long)stringTable.size()) {
            return stringTable.get((int)index);
        }
        return null;
    }

    public static String extractLabel(ProfileProto.Sample sample, List<String> stringTable, String ... keys) {
        for (ProfileProto.Label l : sample.getLabelList()) {
            String k = PprofSegmentParser.getStringFromTable(l.getKey(), stringTable);
            if (k == null) continue;
            for (String expect : keys) {
                if (!k.equals(expect)) continue;
                return PprofSegmentParser.getStringFromTable(l.getStr(), stringTable);
            }
        }
        return null;
    }

    public static long extractTimestamp(ProfileProto.Sample sample, List<String> stringTable, boolean isStart) {
        String target = isStart ? "startTime" : "endTime";
        for (ProfileProto.Label l : sample.getLabelList()) {
            String k = PprofSegmentParser.getStringFromTable(l.getKey(), stringTable);
            if (k == null || !target.equalsIgnoreCase(k)) continue;
            long v = l.getNum();
            if (v <= 0L) {
                try {
                    String sv = PprofSegmentParser.getStringFromTable(l.getStr(), stringTable);
                    if (sv != null) {
                        v = Long.parseLong(sv.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (v > 0L && v < 1000000000000L) {
                return v * 1000L;
            }
            return v;
        }
        return 0L;
    }

    public static long resolvePeriodMillis(ProfileProto.Profile profile) {
        try {
            long period = profile.getPeriod();
            String unit = null;
            if (profile.hasPeriodType()) {
                unit = PprofSegmentParser.getStringFromTable(profile.getPeriodType().getUnit(), (List<String>)profile.getStringTableList());
            }
            if (period > 0L) {
                if (unit == null || unit.isEmpty() || "nanoseconds".equals(unit) || "nanosecond".equals(unit) || "ns".equals(unit)) {
                    return Math.max(1L, period / 1000000L);
                }
                if ("microseconds".equals(unit) || "us".equals(unit)) {
                    return Math.max(1L, period / 1000L);
                }
                if ("milliseconds".equals(unit) || "ms".equals(unit)) {
                    return Math.max(1L, period);
                }
                if ("seconds".equals(unit) || "s".equals(unit)) {
                    return Math.max(1L, period * 1000L);
                }
                if ("hz".equals(unit) || "HZ".equals(unit)) {
                    return Math.max(1L, 1000L / Math.max(1L, period));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 10L;
    }

    public static class SegmentInfo {
        private String segmentId;
        private String traceId;
        private String spanId;
        private String serviceInstanceId;
        private List<String> stack;
        private long count;

        public String getSegmentId() {
            return this.segmentId;
        }

        public void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public String getSpanId() {
            return this.spanId;
        }

        public void setSpanId(String spanId) {
            this.spanId = spanId;
        }

        public String getServiceInstanceId() {
            return this.serviceInstanceId;
        }

        public void setServiceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        public List<String> getStack() {
            return this.stack;
        }

        public void setStack(List<String> stack) {
            this.stack = stack;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }
}

