/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.DAO;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;

public interface IMetricsDAO
extends DAO {
    public List<Metrics> multiGet(Model var1, List<Metrics> var2) throws Exception;

    public InsertRequest prepareBatchInsert(Model var1, Metrics var2, SessionCacheCallback var3) throws IOException;

    public UpdateRequest prepareBatchUpdate(Model var1, Metrics var2, SessionCacheCallback var3) throws IOException;

    default public boolean isExpiredCache(Model model, Metrics cachedValue, long currentTimeMillis, int ttl) {
        long metricTimestamp = TimeBucket.getTimestamp(cachedValue.getTimeBucket(), model.getDownsampling());
        return currentTimeMillis - metricTimestamp > TimeUnit.DAYS.toMillis(ttl);
    }
}

