/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintRectangle;
import net.sf.jasperreports.engine.xml.print.ReportElementLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class RectangleLoader {
    private static final RectangleLoader INSTANCE = new RectangleLoader();

    public static RectangleLoader instance() {
        return INSTANCE;
    }

    public void loadRectangle(XmlLoader xmlLoader, JasperPrint jasperPrint, Consumer<? super JRPrintRectangle> consumer) {
        JRBasePrintRectangle rectangle = new JRBasePrintRectangle(jasperPrint.getDefaultStyleProvider());
        xmlLoader.setIntAttribute("radius", rectangle::setRadius);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "reportElement": {
                    ReportElementLoader.instance().loadReportElement(xmlLoader, jasperPrint, rectangle);
                    break;
                }
                case "graphicElement": {
                    ReportElementLoader.instance().loadGraphicElement(xmlLoader, rectangle);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        consumer.accept(rectangle);
    }
}

