/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "EPUBTextSink.h"

namespace libepubgen
{

EPUBTextSink::EPUBTextSink()
  : m_lines()
{
}

void EPUBTextSink::insertText(const librevenge::RVNGString &text)
{
  m_lines.back().append(text);
}

void EPUBTextSink::insertLineBreak()
{
  m_lines.push_back(librevenge::RVNGString());
}

void EPUBTextSink::writeTo(EPUBPackage &package, const char *const name)
{
  package.openTextFile(name);

  typedef std::vector<librevenge::RVNGString>::const_iterator LinesIter;
  for (LinesIter it = m_lines.begin(); m_lines.end() != it; ++it)
  {
    if (m_lines.begin() != it)
      package.insertLineBreak();
    package.insertText(*it);
  }

  package.closeTextFile();
}

} // namespace libepubgen

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
